SELECT tsystem.function__drop_by_regex( 'ab2__prior__terminated__get', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.ab2__prior__terminated__get(
    IN _ab2 ab2
    )
    RETURNS ab2
    AS $$

        SELECT ab2.* --, ab2.a2_n
          FROM ab2
          LEFT JOIN ab2_wkstplan ON a2w_a2_id = a2_id AND NOT a2w_marked = -1
          JOIN ksv ON ks_abt = coalesce(a2w_resource_ks_abt_main_fix, a2_ks)
         WHERE a2_ab_ix = _ab2.a2_ab_ix
           AND a2_n < _ab2.a2_n
           AND a2_interm
           AND ks_plan
           AND NOT a2_ende
         ORDER BY a2_n DESC
         LIMIT 1

    $$ LANGUAGE sql STABLE PARALLEL SAFE;
--
CREATE OR REPLACE FUNCTION scheduling.ab2__prior__terminated__get(
    IN _ab2_id integer
    )
    RETURNS ab2
    AS $$

        SELECT scheduling.ab2__prior__terminated__get( ab2 ) FROM ab2 WHERE a2_id = _ab2_id;


    $$ LANGUAGE sql STABLE PARALLEL SAFE;


SELECT tsystem.function__drop_by_regex( 'ab2__prior__get', 'tabk', _commit => true );
CREATE OR REPLACE FUNCTION tabk.ab2__prior__get(
    IN _ab2 ab2,
    IN _filter_out__a2_ende__true bool = false,
    IN _ks_plan_only bool DEFAULT false -- Plantafel: Vorarbeitsgang beendet > nur Planrelevante KS
    )
    RETURNS ab2
    AS $$

        SELECT ab2.* --, ab2.a2_n
          FROM ab2
          LEFT JOIN ab2_wkstplan ON a2w_a2_id = a2_id AND NOT a2w_marked = -1
          JOIN ksv ON ks_abt = coalesce(a2w_resource_ks_abt_main_fix, a2_ks)
         WHERE a2_ab_ix = _ab2.a2_ab_ix
           AND a2_n < _ab2.a2_n
           AND (      _filter_out__a2_ende__true IS false -- alle AGs
                OR ( a2_ende IS false)
                )
           AND (_ks_plan_only IS false OR ks_plan)
         ORDER BY a2_n DESC LIMIT 1

    $$ LANGUAGE sql STABLE PARALLEL SAFE;
--
CREATE OR REPLACE FUNCTION tabk.ab2__prior__get(
    IN _ab2_id integer,
    IN _filter_out__a2_ende__true bool = false,
    IN _ks_plan_only bool DEFAULT false -- Plantafel: Vorarbeitsgang beendet > nur Planrelevante KS
    )
    RETURNS ab2
    AS $$

        SELECT tabk.ab2__prior__get(ab2, _filter_out__a2_ende__true, _ks_plan_only) FROM ab2 WHERE a2_id = _ab2_id;

    $$ LANGUAGE sql STABLE PARALLEL SAFE;


SELECT tsystem.function__drop_by_regex( 'ab2__next__terminated__get', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.ab2__next__terminated__get(
    IN _ab2 ab2
    )
    RETURNS ab2
    AS $$

        SELECT ab2.* --, ab2.a2_n
          FROM ab2
          LEFT JOIN ab2_wkstplan ON a2w_a2_id = a2_id AND NOT a2w_marked = -1
          JOIN ksv ON ks_abt = coalesce(a2w_resource_ks_abt_main_fix, a2_ks)
         WHERE a2_ab_ix = _ab2.a2_ab_ix
           AND a2_n > _ab2.a2_n
           AND a2_interm
           AND ks_plan
           AND NOT a2_ende
         ORDER BY a2_n ASC
         LIMIT 1

    $$ LANGUAGE sql STABLE PARALLEL SAFE;
--
CREATE OR REPLACE FUNCTION scheduling.ab2__next__terminated__get(
    IN _ab2_id integer
    )
    RETURNS ab2
    AS $$

        SELECT scheduling.ab2__next__terminated__get(ab2) FROM ab2 WHERE a2_id = _ab2_id;

    $$ LANGUAGE sql STABLE PARALLEL SAFE;


SELECT tsystem.function__drop_by_regex( 'ab2__next__get', 'tabk', _commit => true );
CREATE OR REPLACE FUNCTION tabk.ab2__next__get(
    IN _ab2 ab2,
    -- _only_isterminable => nur laufende
    IN _filter_out__a2_ende__true bool = false,
    IN _ks_plan_only bool DEFAULT false -- Plantafel: Vorarbeitsgang beendet > nur Planrelevante KS
    )
    RETURNS ab2
    AS $$

        SELECT ab2.* --, ab2.a2_n
          FROM ab2
          LEFT JOIN ab2_wkstplan ON a2w_a2_id = a2_id AND NOT a2w_marked = -1
          JOIN ksv ON ks_abt = coalesce(a2w_resource_ks_abt_main_fix, a2_ks)
         WHERE a2_ab_ix = _ab2.a2_ab_ix
           AND a2_n > _ab2.a2_n
           AND (     _filter_out__a2_ende__true IS false -- alle AGs
                OR ( a2_ende IS false) -- nächster nicht beendeter AG
                )
           AND (_ks_plan_only IS false OR ks_plan)
         ORDER BY a2_n ASC
         LIMIT 1

    $$ LANGUAGE sql STABLE PARALLEL SAFE;
--
CREATE OR REPLACE FUNCTION tabk.ab2__next__get(
    IN _ab2_id integer,
    IN _filter_out__a2_ende__true bool = false,
    IN _ks_plan_only bool DEFAULT false -- Plantafel: Vorarbeitsgang beendet > nur Planrelevante KS
    )
    RETURNS ab2
    AS $$

        SELECT tabk.ab2__next__get(ab2, _filter_out__a2_ende__true, _ks_plan_only) FROM ab2 WHERE a2_id = _ab2_id;

    $$ LANGUAGE sql STABLE PARALLEL SAFE;


SELECT tsystem.function__drop_by_regex( 'ab2__next_prior__terminated__get', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.ab2__next_prior__terminated__get(
    IN  _ab2_id integer,
    OUT _prev_ab2_a2_id ab2,
    OUT _next_ab2_a2_id ab2
    )
    RETURNS record
    AS $$

        /*WITH
          _data AS (

            SELECT
                lag(a2_id) over () _prev_ab2_a2_id,
                lead(a2_id) over () _next_ab2_a2_id,
                a2_id
              FROM ab2
              JOIN scheduling.resource_timeline ON
                          ti_a2_id = a2_id
                      AND ti_type IN ( 'task', 'task.buffer' )
             WHERE
                    a2_ab_ix = (
                        SELECT a2_ab_ix
                          FROM ab2
                         WHERE a2_id = _ab2_id
                    )
            GROUP BY a2_id
            ORDER BY a2_id ASC
          )

        SELECT _prev_ab2_a2_id, _next_ab2_a2_id
          FROM _data
         WHERE a2_id = _ab2_id;
        */

        SELECT scheduling.ab2__prior__terminated__get(_ab2_id) AS _prev_ab2,
               scheduling.ab2__next__terminated__get(_ab2_id) AS _next_ab2

    $$ LANGUAGE sql STABLE PARALLEL SAFE;